/*
 * Decompiled with CFR 0.152.
 */
package kotlin.collections;

import java.util.Collection;
import java.util.Iterator;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt__CollectionsJVMKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;

final class ArrayAsCollection
implements Collection,
KMappedMarker {
    private final Object[] values;
    private final boolean isVarargs;

    public ArrayAsCollection(Object[] objectArray, boolean bl) {
        Intrinsics.checkNotNullParameter(objectArray, "values");
        this.values = objectArray;
        this.isVarargs = bl;
    }

    public int getSize() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean contains(Object object) {
        return ArraysKt.contains(this.values, object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsAll(Collection iterator2) {
        Iterator iterator3 = iterator2;
        Intrinsics.checkNotNullParameter(iterator3, "elements");
        if (iterator3.isEmpty()) {
            return true;
        }
        iterator2 = iterator2.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (this.contains(iterator2.next()));
        return false;
    }

    @Override
    public Iterator iterator() {
        return ArrayIteratorKt.iterator(this.values);
    }

    @Override
    public final Object[] toArray() {
        return CollectionsKt__CollectionsJVMKt.copyToArrayOfAny(this.values, this.isVarargs);
    }

    public boolean add(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    public Object[] toArray(Object[] objectArray) {
        Intrinsics.checkNotNullParameter(objectArray, "array");
        return CollectionToArray.toArray(this, objectArray);
    }
}

