/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import java.util.Arrays;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntegerValueConstant;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;

public final class CharValue
extends IntegerValueConstant {
    public CharValue(char c) {
        super(Character.valueOf(c));
    }

    private final String getPrintablePart(char c) {
        return c == '\b' ? "\\b" : (c == '\t' ? "\\t" : (c == '\n' ? "\\n" : (c == '\f' ? "\\f" : (c == '\r' ? "\\r" : (this.isPrintableUnicode(c) ? String.valueOf(c) : "?")))));
    }

    private final boolean isPrintableUnicode(char c) {
        byte by = (byte)Character.getType(c);
        return by != 0 && by != 13 && by != 14 && by != 15 && by != 16 && by != 18 && by != 19;
    }

    @Override
    public SimpleType getType(ModuleDescriptor moduleDescriptor) {
        ModuleDescriptor moduleDescriptor2 = moduleDescriptor;
        Intrinsics.checkNotNullParameter(moduleDescriptor2, "module");
        SimpleType simpleType2 = moduleDescriptor2.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "module.builtIns.charType");
        return simpleType2;
    }

    @Override
    public String toString() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        CharValue charValue = this;
        objectArray2[0] = (int)((Character)this.getValue()).charValue();
        objectArray[1] = charValue.getPrintablePart(((Character)charValue.getValue()).charValue());
        String string = String.format("\\u%04X ('%s')", Arrays.copyOf(objectArray, 2));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        return string;
    }
}

