/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public class ErrorScope
implements MemberScope {
    private final ErrorScopeKind kind;
    private final String debugMessage;

    public ErrorScope(ErrorScopeKind errorScopeKind, String ... stringArray) {
        Intrinsics.checkNotNullParameter((Object)errorScopeKind, "kind");
        Intrinsics.checkNotNullParameter(stringArray, "formatParams");
        this.kind = errorScopeKind;
        String[] stringArray2 = Arrays.copyOf(stringArray, stringArray.length);
        String string = String.format(errorScopeKind.getDebugMessage(), Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        this.debugMessage = string;
    }

    protected final String getDebugMessage() {
        return this.debugMessage;
    }

    @Override
    public ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        String string = String.format(ErrorEntity.ERROR_CLASS.getDebugText(), Arrays.copyOf(new Object[]{name}, 1));
        Intrinsics.checkNotNullExpressionValue(string, "format(this, *args)");
        Name name2 = Name.special(string);
        Intrinsics.checkNotNullExpressionValue(name2, "special(ErrorEntity.ERRO\u2026S.debugText.format(name))");
        return new ErrorClassDescriptor(name2);
    }

    @Override
    public Set getContributedVariables(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        return ErrorUtils.INSTANCE.getErrorPropertyGroup();
    }

    @Override
    public Set getContributedFunctions(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(lookupLocation, "location");
        return SetsKt.setOf((Object)new ErrorFunctionDescriptor(ErrorUtils.INSTANCE.getErrorClass()));
    }

    @Override
    public Collection getContributedDescriptors(DescriptorKindFilter descriptorKindFilter, Function1 function1) {
        Intrinsics.checkNotNullParameter(descriptorKindFilter, "kindFilter");
        Intrinsics.checkNotNullParameter(function1, "nameFilter");
        return CollectionsKt.emptyList();
    }

    @Override
    public Set getFunctionNames() {
        return SetsKt.emptySet();
    }

    @Override
    public Set getVariableNames() {
        return SetsKt.emptySet();
    }

    @Override
    public Set getClassifierNames() {
        return SetsKt.emptySet();
    }

    public String toString() {
        return "ErrorScope{" + this.debugMessage + '}';
    }
}

