#version 150

#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform float GameTime;

out vec4 vertexColor;
out vec2 uv;
flat out int isSelection;

bool approxEqualLow(float a, float b) { return (a < b+0.001 && a > b-0.001); }

bool approxEqual(float a, float b) { return (a < b+0.00001 && a > b-0.00001); }

bool approxEqualV3(vec3 a, vec3 b) { return (lessThan(a, b+0.0001)==bvec3(true) && lessThan(b-0.0001,a)==bvec3(true)); }

void main() {
	vertexColor = Color;
	vec3 position = vec3(0.0);
	vec3 posWithoutOffset = (ProjMat * vec4(Position, 1.0)).xyz;

	if(approxEqualV3(Color.rgb,vec3(1.0)) && approxEqual(Color.a,0.50196) && gl_VertexID > -1 && gl_VertexID < 4) {
		isSelection = 1;
		float padding = 1.0;
		if (Selected_Slot_Anim && sin(GameTime * 6000.0) > 0) padding += 1.0;
		switch(gl_VertexID % 4) {
			case 0:	//RightBottom
			uv = vec2(-1.0, -1.0);
			break;
			case 1: //RightTop
			uv = vec2(-1.0, 1.0);
			break;
			case 2: //LeftTop
			uv = vec2(1.0, 1.0);
			break;
			case 3: //LeftBottom
			uv = vec2(1.0, -1.0);
			break;
		}
		position.xy = uv * padding;
	}

    if(approxEqualV3(Color.rgb, vec3(0.93725,0.19608,0.23922)) && approxEqualLow(min(abs(posWithoutOffset.x),1.0), 1.0) && approxEqualLow(min(abs(posWithoutOffset.y),1.0), 1.0) && gl_VertexID > -1 && gl_VertexID < 4 && Position.z == 0.0) {
		switch(gl_VertexID % 4) {
			case 0: //RightBottom
			vertexColor.rgb = vec3(0, 0, 0);
			break;
			case 1: //RightTop
			vertexColor.rgb = vec3(0.3, 0.1, 0.1);
			break;
			case 2: //LeftTop
			vertexColor.rgb = vec3(0.5, 0.2, 0.1);
			break;
			case 3: //LeftBottom
			vertexColor.rgb = vec3(0.3, 0.1, 0.1);
			break;
		}
    }
	
  gl_Position = ProjMat * ModelViewMat * vec4(Position + position, 1.0);
}
